var card_index;//a
var port_index;//b
var global_rf_index;//a/b
var ControlName = new Array("Server1", "Server2", "Server3", "Server4", "Server5", "Server6");
var casNameGroup = [];
var SERVER_NUM = 6;
var g_RowCount = 0;
var progInfo = [];
var setPidString = "";
var language;
var userName;

function mouseOverShow(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn4_hover.png)";
	}
}
function mouseOutShow(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn4_normal.png)";
	}
}

function mouseOverBig(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn3_hover.png)";
	}
}
function mouseOutBig(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn3_normal.png)";
	}
}

function displayCasName()
{
	var index;
	for(var i = 0; i < SERVER_NUM; i++)
	{
		index = i + 1;
		document.getElementById("Server" + index).innerHTML  = casNameGroup[i];
	}
}

function changeCasGroup()
{
	var xmlhttp = getHTTPObject();
	var selectedGroup = document.getElementById("CasGroup").value;
	var getParams = "type=35&cmd=1&getCasName=1&casGroup=" + selectedGroup;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);

	xmlhttp.onreadystatechange = function()
    {
		if(xmlhttp.readyState == 4)
		{
			var response = xmlhttp.responseText.slice(7, -8);
			casNameGroup = response.split(",");
			displayCasName();
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function ServerParamDisplay(ifIndex)
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=35&cmd=1&getServerParam=1&rfPort=" + global_rf_index + "&serverNo=" + ifIndex;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);

	xmlhttp.onreadystatechange = function()
    {
		if(xmlhttp.readyState == 4)
		{
			var response = xmlhttp.responseText.slice(7, -8);
			var cellCount = 0;
			var ifData = response.split("&");
			var ctrlName = ControlName[ifIndex];

			var data = ctrlName + "Data";
			var ecmDesc = ctrlName + "EcmDesc";
			
			/* Column - Sub CAS ID */
			document.getElementById(data).innerHTML = ifData[cellCount];
			
			/* Column - ECM Channel ID */
			cellCount++;
			document.getElementById(ecmDesc).value = ifData[cellCount];
			
			ifIndex++;
			if(ifIndex >= SERVER_NUM)
			{
				document.body.style.cursor = "auto";
				window.status = "Done";
			}
			else
			{
				ServerParamDisplay(ifIndex);
			}
		}/* End of readyState */
	}/* End of onreadystatechange */
	xmlhttp.send(getParams);
	return true;
}

function NormalParamDisplay()
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=35&cmd=1&getNormalParam=1&rfPort=" + global_rf_index;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
    {
		if(xmlhttp.readyState == 4)
		{
			var response = xmlhttp.responseText.slice(7, -8);
			var ifData = response.split("&");
			var cellCount = 0;
			var intData = 0;
			
			/* Column - CAS Group */
			document.getElementById("CasGroup").value = parseInt(ifData[cellCount]);
			
			/* Column - Key Mode */
			cellCount++;
			document.getElementById("KeyMode").value = parseInt(ifData[cellCount]);
			
			/* Column - Fixed Key */
			cellCount++;
			document.getElementById("FixedKey").value = ifData[cellCount];
			
			/* Column - CAT Filt */
			cellCount++;
			document.getElementById("CatFilt").value = parseInt(ifData[cellCount]);
			
			/* Column - SCG ID */
			cellCount++;
			document.getElementById("ScgId").value = parseInt(ifData[cellCount]);
			
			cellCount++;
			casNameGroup = ifData[cellCount].split(",");
			displayCasName();
						
			EnableKey();
			//changeCasGroup();
			ServerParamDisplay(0);			
		}/* End of readyState */
	}/* End of onreadystatechange */
	xmlhttp.send(getParams);
	return true;
}

function PageLoadHandler()
{
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	DisableApply();
	
	NormalParamDisplay();
}

function pageRefresh()
{
	PageLoadHandler();
}

window.onload = function()
{
	var args = getArgs();
	userName = args["userName"];	
	var group = args["group"];
	var apply = document.getElementById("Apply");
	applyDispay(group, apply);
	
	language = document.getElementById("language").value;
	var nodeId = args["nodeId"];
	if(nodeId == null)
	{
		nodeId = parent.curTree.getSelectedNodes()[0].nId;
	}
	var str = nodeId.split("_");
	card_index = parseInt(str[1]);
	port_index = parseInt(str[2]);
	
	global_rf_index = card_index + "/" + port_index;
	
	PageLoadHandler();
	//document.getElementById("AdvSectionDiv").style.display = "none";
}

function DisableApply()
{
	disabledButton(document.getElementById("Apply"), true);
}

function EnableApply()
{
	disabledButton(document.getElementById("Apply"), false);
}

function EnableKey()
{
	if(document.getElementById("KeyMode").value == 1)
	{
		document.getElementById("FixedKey").disabled = false;
	}
	else
	{
		document.getElementById("FixedKey").disabled = true;
	}
}

function GenerateServerParam(ifIndex)
{
	var typeStr;
	var params = "";

	typeStr = "Data";
	var Data = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + Data + "&";
	
	typeStr = "EcmDesc";
	var EcmDesc = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + EcmDesc + "&";
	
	return params;
}

function ServerParamConfig()
{
	var xmlhttp = getHTTPObject();
	var params = "type=35&cmd=2&userName=" + userName + "&setServerParam=1&rfPort=" + global_rf_index + "&";
		
	for(var i = 0; i < SERVER_NUM; i++)
	{
		params = params + GenerateServerParam(i);
	}
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(language == 0)
			{
				alert("RF scramble configuration updated successfully.");
			}
			else
			{
				alert("RF加扰参数设置成功。");
			}
			PageLoadHandler();
		}
	}
	xmlhttp.send(params);
	return true;
}

function GenerateNormalParam()
{
	var data ;
	var typeStr;
	var params = "";
	
	typeStr = "CasGroup";
	data = document.getElementById(typeStr).value;
	params = typeStr + "=" + data;
		
	typeStr = "KeyMode";
	data = document.getElementById(typeStr).value;
	params = params + "&" + typeStr + "=" + data;

	if(document.getElementById("KeyMode").value == 1)
	{
		typeStr = "FixedKey";
		data = document.getElementById(typeStr).value;
		params = params + "&" + typeStr + "=" + data;
	}
		
	typeStr = "CatFilt";
	data = document.getElementById(typeStr).value;
	params = params + "&" + typeStr + "=" + data;
	
	typeStr = "ScgId";
	data = document.getElementById(typeStr).value;
	params = params + "&" + typeStr + "=" + data;

	return params;
}

function NormalParamConfig()
{
	var params = "type=35&cmd=2&userName=" + userName + "&setNormalParam=1&rfPort=" + global_rf_index + "&" + GenerateNormalParam();
	var xmlhttp = getHTTPObject();
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			ServerParamConfig();
		}
	}
	xmlhttp.send(params);
	return true;
}

function setScramConfig()
{
	if(ValidateAllInput() == false)
	{
		return false;
	}
	
	DisableApply();
	document.body.style.cursor = "wait";
	window.status = "Applying settings, please wait...";
	NormalParamConfig();		
}

function ValidateID(obj)
{
	
}

function ValidatePID(obj)
{
	
}

function ValidateKey(obj)
{
	
}

function ValidString(obj, length)
{
	var input = obj.value;
	if(validateString(input, length, language) == false)
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function ValidateAllInput()
{
	var obj;
	for(var i = 0; i < SERVER_NUM; i++)
	{
		obj = document.getElementById(ControlName[i] + "Data");
		if(ValidString(obj) == false)
		{
			return false;
		}

		obj = document.getElementById(ControlName[i] + "EcmDesc");
		if(ValidString(obj) == false)
		{
			return false;
		}
	}
	
	obj = document.getElementById("FixedKey");
	if(ValidateKey(obj) == false)
	{
		return false;
	}
	
	obj = document.getElementById("ScgId");
	if(ValidateID(obj) == false)
	{
		return false;
	}
	
	return true;
}